from scripts.config import DatabaseConstants


class DatabaseNames:
    ilens_assistant = "ilens_assistant"
    ilens_configuration = DatabaseConstants.metadata_db


class CollectionNames:
    oee_tags = "oeetags"
    customer_projects = "customer_projects"


class TableContent:
    FETCH_STEP_HEADER_CONTENT = [
        {
            "value": "step_name",
            "label": "Step Name",
            "enableClick": True,
            "style": "indicate-item cursor-pointer",
            "action": {"action": "edit", "label": "Edit", "type": "edit"}
        },
        {
            "value": "description",
            "label": "Description"
        }
    ]
    fetch_step_table_actions = {
        "actions": [
            {
                "action": "edit",
                "label": "Edit",
                "type": "edit",
                "icon-class": "fa fa-pencil"
            },
            {
                "action": "delete",
                "label": "Delete",
                "type": "delete",
                "icon-class": "fa fa-trash"
            }
        ],
        "enableActions": True,
        "externalActions": [
            {
                "action": "addnew",
                "label": "Create New",
                "type": "addnew"
            }
        ]
    }


class StatusResponses:
    PLANNED = "PLANNED"
    ALL = "ALL"
    PENDING = "PENDING"
    COMPLETED = "COMPLETED"
    PENDING_FOR_REVIEW = "PENDING_FOR_REVIEW"
    PENDING_FOR_APPROVAL = "PENDING_FOR_APPROVAL"
    IN_PROGRESS = "IN_PROGRESS"
    REVIEW_REJECTED = "REVIEW_REJECTED"
    APPROVAL_REJECTED = "APPROVAL_REJECTED"
    APPROVED = "APPROVED"
    IS_STARTED = "is_started"
    IS_TASK_COMPLETED = "is_task_completed"
    IS_PAUSED = "is_paused"
    CLOSED = "CLOSED"
    RESOLVED = "RESOLVED"


class UserRoleCollectionKeys:
    KEY_USER_ROLE_ID = "user_role_id"
    KEY_PROJECT_ID = "project_id"


class SiteConfCollectionKeys:
    KEY_SITE_NAME = "site_name"
    KEY_SITE_INFO = "site_info"
    KEY_CUSTOMER_PROJECT_ID = "customer_project_id"
    KEY_SITE_ID = "site_id"
    KEY_PRODUCT_ENCRYPTED = "product_encrypted"
    KEY_PROCESS_ID = "process_id"


class CustomerProjectKeys:
    KEY_CUSTOMER_PROJECT_ID = "customer_project_id"
    KEY_CUSTOMER_PROJECT_NAME = "customer_project_name"
    KEY_SITE_TEMPLT_ID = "site_templt_id"
    KEY_PROCESS_TEMPLT_ID = "process_templt_id"


class DBConsts:
    kairos_std_metric_name = 'ilens.live_data.raw'
    kairos_column_names = ["timestamp", "value"]
    kairos_time_unit = "ms"
    kairos_version_api = "/api/v1/version"
    kairos_health_check = "/api/v1/health/status"
    kairos_query_api = "/api/v1/datapoints/query"
    kairos_write_data_api = "/api/v1/datapoints"


class Secrets:
    LOCK_OUT_TIME_MINS = 30
    leeway_in_mins = 10
    unique_key = '45c37939-0f75'
    token = '8674cd1d-2578-4a62-8ab7-d3ee5f9a'
    issuer = "ilens"
    alg = "RS256"


class StepCategories:
    NON_PERIODIC = "step_category_100"
    TASK_CREATION = "step_category_101"
    PERIODIC = "step_category_102"
    TRIGGER_BASED = "step_category_103"


class CommonStatusCode:
    SUCCESS_CODES = (
        200,
        201,
        204,
    )


class EmailAuth:
    username = 'AllGoodNamesRGone'
    password = 'comBRANSeANtamasEbICaPeC'


class JsonFormats:
    missed_task_format = {
        "className": "scheduledTask",
        "end": "NA",
        "id": "",
        "start": "",
        "title": "",
        "textColor": "#000000",
        "backgroundColor": "",
        "data": {
            "future_task": True,
            "id": "",
            "info": {
                "Logbook Name": "",
                "Hierarchy": "",
                "Created By": ""
            },
            "critical": False,
            "task_category": "",
            "bgColor": "",
            "created_at": ""
        }
    }
