import os
from collections import namedtuple


class Endpoints:
    calc_oee_base = "/calculator"
    calculate_batch_oee = "/batch_oee/calculate"
    update_batch_oee = "/batch_oee/update"

    api_batches = "/batches"
    get_batch_oee_all = "batch_oee/get/all"
    get_batch_oee_batch_id = "batch_oee/get/one_batch"
    api_get = "/get"
    api_chart_data = "/chart_data"
    get_layout = "/get_layout"
    save_layout = "/save_layout"

    # Meta services
    api_hierarchy = "/hierarchy"
    hierarchy_api = 'ilens_config/get_site_level_hierarchy'

    # OEE SERVICES
    oee_services = "/oee"
    oee_services = "/oee_post"

    # tag_lists
    api_tags_lists = "/tag_lists"
    api_tags = "/tags"


class StatusCodes:
    SUCCESS = "success"
    FAILED = "failed"
    SUCCESS_CODES = [200, 201, 204]


class ResponseCodes:
    SUCCESS = "success"


class UOM:
    minutes = "mins"
    seconds = "secs"
    hours = "hrs"
    millis = "msecs"

    Divisor = namedtuple("Divisor", ["minutes", "seconds", "hours", "millis"])
    time_divs = Divisor(60000, 1000, 360000, 1)


class Secrets:
    LOCK_OUT_TIME_MINS = 30
    leeway_in_mins = 10
    unique_key = '45c37939-0f75'
    token = '8674cd1d-2578-4a62-8ab7-d3ee5f9a'
    issuer = "ilens"
    alg = "RS256"


class CommonKeys:
    KEY_TYPE = "type"
    KEY_CONTENT_TYPE = "content_type"


class DBConstants:
    # Databases
    db_events = "ilens_events"
    db_metadata = "ilens_configuration"
    db_ebpr = "ilens_ebpr"
    db_ilens_assistant = "ilens_assistant"

    collection_constants = "constants"
    collection_tag_hierarchy = "tag_hierarchy"


class EndpointConstants:
    hierarchy_downtime = "/downtime_log/get/overall_downtime"


class TagCategoryConstants:
    TOTAL_UNITS_CATEGORY = os.environ.get("TOTAL_UNITS_CATEGORY", default="OEE - Total Produced Units")
    REJECT_UNITS_CATEGORY = os.environ.get("TOTAL_UNITS_CATEGORY", default="OEE - Reject Units")


class CommonConstants:
    ui = 'ui_datetime_format'
    utc = 'utc_datetime_format'
    nsc = 'no_special_chars_datetime_format'
    USER_META_TIME_FORMAT = "%Y-%m-%d %H:%M:%S"
    umtf = 'user_meta_time_format'
    __temporary_format__ = '%Y-%m-%dT%H:%M:%S+0530'
    __iso_format__ = '%Y-%m-%dT%H:%M:%S%z'
    __form_iso_format__ = '%Y-%m-%dT%H:%M:%S.%f%z'
    __utc_datetime_format__ = '%Y-%m-%dT%H:%M:%S'
    __ui_datetime_format__ = '%Y-%m-%d %H:%M:%S'
    __no_special_chars_datetime_format__ = '%Y%m%d%H%M%S'
    __user_meta_time_format__ = "%d-%m-%Y %H:%M:%S"
    __user_meta_time_format_ws__ = "%d-%m-%Y %H:%M"
    __ui_display_datetime_format__ = "%d %b %Y %H:%M"
    __ui_display_date_format__ = "%d %b %Y"
    __time_format__ = "%H:%M:%S"


class CommonStatusCode:
    SUCCESS_CODES = (
        200,
        201,
        204,
    )


class TagHierarchyKeys:
    KEY_ID = "id"
    KEY_SITE_ID = "site_id"
    KEY_SITE_NAME = "site_name"
    KEY_DEPT_ID = "dept_id"
    KEY_DEPT_NAME = "dept_name"
    KEY_LINE_ID = "line_id"
    KEY_LINE_NAME = "line_name"
    KEY_EQUIPMENT_ID = "equipment_id"
    KEY_EQUIPMENT_NAME = "equipment_name"
    KEY_PARAMETER_ID = "parameter_id"
    KEY_PROJECT_ID = "project_id"
    KEY_LOWER_LIMIT = "lower_limit"
    KEY_UPPER_LIMIT = "upper_limit"
    KEY_DETAILS_LEVEL = "kpi_details"
    KEY_KPI_LEVEL = "kpi_level_list"
    KEY_KPI_PARENT = "kpi_parent_list"
    KEY_TAG_CATEGORY_ID = "tag_category_id"
    KEY_TAG_CODE = "tag_code"
    KEY_TAG_REGISTER = "tag_register"
    KEY_STARRED = "starred"
    KEY_ASSET_MODEL_ID = "asset_model_id"
    KEY_ASSET_VERSION = "asset_version"
    KEY_additional_fields = "additional_fields"


class CommonKeys:
    KEY_CREATED_BY = "created_by"
    KEY_CREATED_TIME = "created_at"
    KEY_COMPLETED_AT = "completed_at"
    KEY_UPDATED_AT = "updated_by"
    KEY_LAST_UPDATED_TIME = "updated_at"
