import json
import os

from fastapi import FastAPI, Request, Response
from fastapi.middleware.cors import CORSMiddleware

from scripts.services.calculate_oee import calc_oee_router
from scripts.services.form_services import form_router
from scripts.services.meta_services import meta_service_router
from scripts.services.ui_services import ui_service_router

app = FastAPI(
    title="iLens OEE V3",
    version="5.5.0",
    description="OEE App",
    docs_url=os.environ.get("SW_DOCS_URL"),
    openapi_url=os.environ.get("SW_OPENAPI_URL")
)
if os.environ.get("CORS_URLS").split(","):
    app.add_middleware(
        CORSMiddleware,
        allow_origins=os.environ.get("CORS_URLS").split(","),
        allow_credentials=True,
        allow_methods=["GET", "POST", "DELETE", "PUT"],
        allow_headers=["*"]
    )


@app.middleware("http")
async def add_process_time_header(request: Request, call_next):
    cookies = request.cookies
    response: Response = await call_next(request)
    response.headers.append("Cookie", json.dumps(cookies))
    return response


app.include_router(calc_oee_router)
app.include_router(ui_service_router)
app.include_router(meta_service_router)
app.include_router(form_router)
