import json
from functools import lru_cache

from scripts.db.redis_connections import project_details_db


@lru_cache()
def get_db_name(redis_client, project_id: str, database: str, delimiter="__"):
    if not project_id:
        return database
    val = redis_client.get(project_id)
    if val is None:
        raise ValueError(
            f"Unknown Project, Project ID: {project_id} Not Found!!!")
    val = json.loads(val)
    if not val:
        return database

    # Get the prefix flag to apply project_id prefix to any db
    prefix_condition = bool(
        val.get("source_meta", {}).get("add_prefix_to_database"))

    if prefix_condition:
        # Get the prefix name from mongo or default to project_id
        prefix_name = val.get("source_meta", {}).get("prefix") or project_id
        return f"{prefix_name}{delimiter}{database}"
    return database


@lru_cache()
def get_project_specific_key(project_id=None, delimiter="__"):
    if not project_id:
        return ""
    specific_key = ""
    prefix_detail = project_details_db.get(project_id)
    if prefix_detail is not None:
        prefix_detail = json.loads(prefix_detail)
        if prefix_detail.get('source_meta', {}).get('add_prefix_to_database', False):
            specific_key = prefix_detail.get('source_meta').get('prefix') + delimiter
    return specific_key
