class TagHierarchyAggregate:
    @staticmethod
    def tag_aggregate(project_id, hierarchy_id):
        query = [
            {
                '$match': {
                    'project_id': project_id,
                    'id': {
                        '$regex': f'{hierarchy_id}\\$tag'
                    }
                }
            }, {
                '$lookup': {
                    'from': 'tag_category',
                    'localField': 'tag_category_id',
                    'foreignField': 'tag_category_id',
                    'as': 'tag_category'
                }
            }, {
                '$unwind': {
                    'path': '$tag_category'
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            'k': '$tag_category.tag_category_name',
                            'v': '$id'
                        }
                    }
                }
            }, {
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            }
        ]
        return query
