from scripts.constants.db_connections import mongo_client
from scripts.db.mongo.ilens_oee.collections.oee_layouts import OEELayouts, OeeLayoutCollection
from scripts.schemas.layout import SaveLayoutRequest, GetLayoutRequest


class LayoutHandler:
    def __init__(self, project_id=None):
        self.oee_layout_conn = OEELayouts(project_id=project_id, mongo_client=mongo_client)

    async def save_layout(self, layout_request: SaveLayoutRequest):
        try:
            data = self.oee_layout_conn.update_layout(
                data=layout_request.dict(), project_id=layout_request.project_id
            )
            return data
        except Exception:
            raise

    async def fetch_layout(self, layout_request: GetLayoutRequest):
        try:
            data: OeeLayoutCollection = self.oee_layout_conn.find_layout(
                layout_request.project_id
            )
            return data.data
        except Exception:
            raise
