from fastapi import APIRouter
from scripts.logging import logger
from scripts.constants import Endpoints
from scripts.schemas.batch_oee import GetOeeServices
from scripts.core.handlers import oee_handlers

oee_services = APIRouter(prefix=Endpoints.oee_services, tags=["OEE Calculator"])


@oee_services.post(Endpoints.oee_services)
async def oee_tag_mapping(oee_tag_mapping_list: GetOeeServices):
    try:
        tag_mapping = oee_tag_mapping_list.dict()
        result = oee_handlers.Oee_services.oee_tag_mapping(tag_mapping)

    except Exception as e:
        logger.exception("Exception occured while inserting data")

    return result


@oee_services.post(Endpoints.oee_services)
async def get_oee_tag_mapping(get_oee_tags: GetOeeServices):
    try:
        get_oee_tags = get_oee_tags.dict()
        return_json = oee_handlers.Oee_services.get_oee_tag_mapping(get_oee_tags)

    except Exception as e:
        logger.exception(f"Error while getting information as {e}")

    return return_json


@oee_services.post(Endpoints.oee_services)
async def delete_oee_tagging(delete_oee_tags: GetOeeServices):
    try:
        delete_oee_tags = delete_oee_tags.dict()
        return_json = oee_handlers.Oee_services.delete_oee_tags(projec_id=delete_oee_tags["project_id"])

    except Exception as e:
        logger.exception(f"Error while getting information as {e}")

    return return_json


@oee_services.post(Endpoints.oee_services)
async def updaye_oee_tagging(update_oee_tags: GetOeeServices):
    try:
        update_oee_tags = update_oee_tags.dict()
        return_json = oee_handlers.Oee_services.update_oee_services(update_oee_tags)

    except Exception as e:
        logger.exception(f"Error while getting information as {e}")

    return return_json
