import traceback

from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session
from pydantic import ValidationError
from scripts.constants import Endpoints
from scripts.core.handlers.batch_oee_calc_handler import CalculateBatchOEEHandler
from scripts.db.psql.databases import get_db
from scripts.logging import logger

from scripts.schemas.batch_oee import BatchOEEDataRequest
from scripts.schemas.response_models import DefaultFailureResponse
from scripts.errors import ILensError
import json

batch_oee_handler = CalculateBatchOEEHandler()
calc_oee_router = APIRouter(prefix=Endpoints.calc_oee_base, tags=["OEE Calculator"])


@calc_oee_router.post(Endpoints.calculate_batch_oee)
async def calculate_oee_for_batch(
        product_info: BatchOEEDataRequest, db: Session = Depends(get_db)
):
    try:
        return await batch_oee_handler.calculate_oee(product_info=product_info, db=db)
    except ILensError as error_code:
        return DefaultFailureResponse(error=error_code.args[0])
    except ValidationError as e:
        return DefaultFailureResponse(error=json.loads(e.json()))
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args)


@calc_oee_router.post(Endpoints.update_batch_oee)
def calculate_oee_for_batch(
        product_info: BatchOEEDataRequest, db: Session = Depends(get_db)
):
    try:
        return batch_oee_handler.calculate_oee(product_info=product_info, db=db)
    except ValidationError as e:
        return DefaultFailureResponse(error=json.loads(e.json()))
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args)
