from scripts.logging import logger
from scripts.utils.mongo_util import MongoCollectionBaseClass

from scripts.constants.db_connections import mongo_client


class Oee_services:
    def __init__(self):
        try:
            self.connect = MongoCollectionBaseClass(mongo_client=mongo_client, database="ilens_configuration",
                                                    collection="oee_tag_mapping")
        except Exception as e:
            logger.exception("Error while connecting to mongodb")

    async def oee_tag_mapping(self, oee_tag_mapping_list):
        try:
            return_json = {"message": "failure", "status": "failure", "message": "data not inserted in to mongodb"}
            insert_json = {"hierarchy": oee_tag_mapping_list.get("hierarchy", ""),
                           "project_id": oee_tag_mapping_list.get("project_id", ""),
                           "meta": oee_tag_mapping_list.get("project_id", ""),
                           "oee_tag_mapping": oee_tag_mapping_list.get("oee_tag_mapping", {})
                           }
            result = self.connect.insert_one(data=insert_json)
            if result:
                logger.info("Data inserted in to mongodb successfully")
                return_json["message"] = "success"
                return_json["status"] = "success"
            else:
                logger.info("Unable to insert data in to Mongodb")

        except Exception as e:
            logger.exception("Error occured while inserting data")

        return return_json

    async def get_oee_tag_mapping(self, get_oee_tag, ):
        try:
            return_json = {"message": "failure", "status": "failure", "data": "data not found"}
            query = {'project_id': get_oee_tag.get("project_id", "")}
            skips = get_oee_tag.get("page_size") * (get_oee_tag("page_num") - 1)
            no_of_documents = self.connect.count_documents(query=query)
            result = self.connect.find(query=query).skip(skips).limit(get_oee_tag.get("page_num"))
            if result:
                return_json["message"] = "success"
                return_json["status"] = "success"
                return_json["data"] = result
                return_json["total_records"] = no_of_documents
                if skips < no_of_documents:
                    return_json["endOfrecords"] = False
                else:
                    return_json["endOfrecords"] = True
        except Exception as e:
            logger.exception(f"Exception occured while fetching data as {e}")
        return result

    async def delete_oee_tags(self, project_id):
        try:
            return_json = {"message": "failure", "status": "failure", "data": "data not found"}
            query = {"project_id": project_id}
            result = self.connect.delete_one(query=query)
            if result:
                return_json["message"] = "success"
                return_json["status"] = "success"
                return_json["data"] = result
        except Exception as e:
            logger.exception(f"Exception occured while fetching data as {e}")
        return result

    async def update_oee_tags(self, update_oee_tags):
        try:
            return_json = {"message": "failure", "status": "failure", "data": "data not found"}
            query = {"project_id": update_oee_tags['projec_id']}
            result = self.connect.update_one(query=query, data=return_json)
            if result:
                return_json["message"] = "success"
                return_json["status"] = "success"
                return_json["data"] = result
        except Exception as e:
            logger.exception(f"Exception occured while fetching data as {e}")
        return return_json
