from scripts.db.mongo.dbs.oee_layouts import OeeLayoutCollectionQueries
from scripts.schemas.layout import SaveLayoutRequest, GetLayoutRequest
from scripts.db.mongo.dbs.oee_layouts import OeeLayoutCollection


class LayoutHandler:
    def __init__(self):
        self.layout_con = OeeLayoutCollectionQueries()

    async def save_layout(self, layout_request: SaveLayoutRequest):
        try:
            data = self.layout_con.update_layout(
                layout_request.dict(), layout_request.project_id
            )
            return data
        except Exception:
            raise

    async def fetch_layout(self, layout_request: GetLayoutRequest):
        try:
            data: OeeLayoutCollection = self.layout_con.find_layout(
                layout_request.project_id
            )
            return data.data
        except Exception:
            raise
