from ilens_kafka_publisher.v2 import KafkaPublisher

from scripts.config import KafkaConf


from scripts.logging import logger


class DataPush:
    def __init__(self):
        try:
            self.obj = KafkaPublisher(kafka_host=KafkaConf.host,
                                      kafka_port=int(KafkaConf.port),
                                      kafka_topic=KafkaConf.topic,
                                      redis_client=partition_db,
                                      enable_sites_partition=KafkaConf.enable_sites_partition,
                                      split_key=KafkaConf.split_key,
                                      round_robin_enable=KafkaConf.round_robin_enable)
        except Exception as e:
            logger.error(f"Could not connect to Kafka: {e}")

    def publish_message(self, msg):
        try:
            self.obj.perform_task(msg)
        except Exception as e:
            logger.debug(f"Failed to publish message - {e}")
            logger.debug(f"Trying reconnect")
