class ErrorMessages:
    UNKNOWN = "Unknown Error occurred"
    ERR001 = "Configurations not available, please verify the database."
    ERR002 = "Data Not Found"


class ErrorCodes:
    ERR001 = "ERR001 - Operating Time is greater than Planned Time"
    ERR002 = "ERR002 - Zero Values are not allowed"
    ERR003 = "ERR003 - Operating Time is less than Productive Time"
    ERR004 = "ERR004 - Rejected Units is greater than Total Units"
    ERR005 = "ERR005 - Batch Start time not supplied"


class UnknownError(Exception):
    pass


class KairosDBError(Exception):
    pass


class UnauthorizedError(Exception):
    pass


class ILensError(Exception):
    pass


class NameExists(Exception):
    pass


class InputRequestError(ILensError):
    pass


class IllegalTimeSelectionError(ILensError):
    pass


class DataNotFound(Exception):
    pass


class AuthenticationError(ILensError):
    """
    JWT Authentication Error
    """


class JWTDecodingError(Exception):
    pass


class DuplicateReportNameError(Exception):
    pass


class PathNotExistsException(Exception):
    pass


class ImplementationError(Exception):
    pass
