from sqlalchemy import Column, Integer, String, Float, TIMESTAMP

from scripts.db.psql.databases import Base


class OEEDiscreteTable(Base):
    __tablename__ = "oee_discrete"
    id = Column(Integer, autoincrement=True, primary_key=True)
    hierarchy = Column(String)
    process = Column(String, nullable=True)
    prod_status = Column(String, default="running")
    reference_id = Column(String, nullable=True, unique=True)
    prod_start_time = Column(TIMESTAMP(timezone=True), nullable=False)
    prod_end_time = Column(TIMESTAMP(timezone=True), nullable=True)
    downtime = Column(Float, default=0)
    total_units = Column(Float)
    reject_units = Column(Float, default=0)
    cycle_time = Column(Float)
    productive_time = Column(Float, default=0)
    availability = Column(Float)
    performance = Column(Float)
    quality = Column(Float)
    availability_loss = Column(Float)
    quality_loss = Column(Float)
    performance_loss = Column(Float)
    oee = Column(Float)
    calculated_on = Column(TIMESTAMP(timezone=True), nullable=False)
    uom = Column(String, default="mins")
    setup_time = Column(Float, default=0)
    tz = Column(String, default="Asia/Kolkata")
    trigger_by = Column(String, nullable=False)
    project_id = Column(String, nullable=False)
