from scripts.core.handlers.oee_handlers import OeeServices
from scripts.logging import logger
from scripts.constants import Endpoints
from scripts.schemas.batch_oee import GetOeeServices
from scripts.core.handlers import oee_handlers
import traceback
from fastapi import APIRouter, Depends
from scripts.utils.security_utils.cookie_decorator import MetaInfoCookie, MetaInfoSchema
from scripts.schemas.response_models import DefaultFailureResponse, DefaultResponse
from scripts.utils.security_utils.cookie_decorator import MetaInfoCookie
from scripts.db.psql.databases import get_db
from scripts.utils.security_utils.decorators import CookieAuthentication

get_cookies = MetaInfoCookie()
oee_config_router = APIRouter(prefix=Endpoints.api_oee_services, tags=["OEE Configuration"])
auth = CookieAuthentication()


@oee_config_router.post(Endpoints.api_save_tag)
async def save_oee_tag(request_data: GetOeeServices, user_id=Depends(auth), db=Depends(get_db),
                 meta: MetaInfoSchema = Depends(get_cookies)):
    try:
        oee_services = OeeServices(project_id=meta.project_id)
        result = oee_services.oee_tag(request_data, user_id, db)
        if result:
            return DefaultResponse(status="success",message='Oee Tag Saved Successfully', data=result)
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args)


@oee_config_router.post(Endpoints.api_get_tag)
async def get_oee_tag(request_data: GetOeeServices, db=Depends(get_db),
                meta: MetaInfoSchema = Depends(get_cookies)):
    try:
        oee_services = OeeServices(project_id=meta.project_id)
        result = oee_services.get_oee_tag(request_data, db)
        if result:
            return DefaultResponse(message='Record Fetched Successfully', data=result)
        return DefaultFailureResponse(status='failed', message='Record Not Found', data={})
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args).dict()


@oee_config_router.post(Endpoints.api_delete_tag)
async def delete_oee_tag(request_data: GetOeeServices, db=Depends(get_db),
                   meta: MetaInfoSchema = Depends(get_cookies)):
    try:
        oee_services = OeeServices(project_id=meta.project_id)
        result = oee_services.delete_oee_tags(request_data, db)
        if result:
            return DefaultResponse(message='Record Deleted Successfully', data=result)
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args).dict()


@oee_config_router.post(Endpoints.api_update_tag)
async def update_oee_tag(request_data: GetOeeServices, db=Depends(get_db),
                   meta: MetaInfoSchema = Depends(get_cookies)):
    try:
        oee_services = OeeServices(project_id=meta.project_id)
        result = oee_services.update_oee_tags(request_data, db)
        if result:
            return DefaultResponse(message='DowntimeLog Updated Successfully', data=result)
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args).dict()
