from pydantic import BaseModel

from typing import Any, Optional

from scripts.constants import CommonKeys
from scripts.db.mongo.ilens_configuration import database
from scripts.db.mongo.ilens_configuration.collections import collection_constants
from scripts.utils.mongo_util import MongoCollectionBaseClass


class ConstantsSchema(BaseModel):
    type: Optional[str]
    data: Optional[Any]
    map_json: Optional[Any]
    content_type: Optional[Any]
    content: Optional[Any]


class Constants(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=database,
                         collection=collection_constants)
