from typing import Optional, Union, List

from pydantic import BaseModel, validator


# from scripts.utils.common_utils import CommonUtils
#
# common_utils = CommonUtils()


class GetProducts(BaseModel):
    queryDate: List[int]
    hierarchy: str
    project_id: Optional[str]


class WaterFallChart(BaseModel):
    performance_loss: float
    quality_loss: float
    availability_loss: float
    oee: float

    @validator("*")
    def round_float(cls, v):
        return round(v, 2)


class ChartRequest(BaseModel):
    project_id: str
    queryDate: List[int]
    hierarchy: Optional[str]
    productId: Optional[str]
    aggregation: Optional[bool] = False


class ChartDBResponse(BaseModel):
    total_units: float
    reject_units: int
    oee: int
    availability: float
    downtime: int
    performance: int
    performance_loss: float
    quality: int
    availability_loss: float
    quality_loss: float
    cycle_time: float
    batch_start_time: int
    batch_end_time: int
    good_units: Optional[float]
    actual_cycle: Optional[float]
    ideal_cycle: Optional[float]
    total_time: Optional[float]
    productive_time: int
    downtime: int

    @validator("*")
    def round_float(cls, v):
        return round(v, 2)


class ChartResponse(BaseModel):
    total_units: float
    reject_units: int
    oee: int
    availability: float
    downtime: int
    performance: int
    quality: int
    actual_cycle: float
    ideal_cycle: float
    good_units: float
    availability_loss: float
    quality_loss: float
    performance_loss: float
    total_time: float
    productive_time: int


class DowntimeLogsRequest(BaseModel):
    project_id: str
    start_time: int
    end_time: int
    hierarchy: str


class ProductInfo(BaseModel):
    product_start_time: int
    product_end_time: int
    hierarchy: str
    product_id: str
    setup_time: Optional[Union[float, int]] = 0
    cycle_time: Union[float, int]
    total_units: Union[float, int]
    reject_units: Optional[Union[float, int]] = 0


class OEEDataInsertRequest(BaseModel):
    prod_start_time: Optional[str]
    prod_end_time: Optional[str]
    prod_status: Optional[str] = "running"
    downtime: Optional[Union[float, int]]
    hierarchy: Optional[str]
    reference_id: Optional[str]
    setup_time: Optional[Union[float, int]]
    cycle_time: Optional[Union[float, int]]
    total_units: Optional[Union[float, int]]
    reject_units: Optional[Union[float, int]]
    tz: Optional[str] = 'Asia/Kolkata'
    project_id: str
    trigger_by: Optional[str]
    uom: Optional[str]

    class Config:
        schema_extra = {
            "example": {
                "hierarchy": "site_100$dept_100$line_100$equipment_100",
                "prod_start_time": "2022-04-22 19:49:00",
                "prod_end_time": "2022-04-22 19:49:00",
                "tz": "Asia/Kolkata",
                "project_id": "project_099",
                "reference_id": "reference_id",
                "downtime": "",
                "setup_time": "",
                "cycle_time": "",
                "total_units": "",
                "reject_units": "",
                "uom": "'"
            }
        }

    # @validator('prod_start_time')
    # def date_format_validator_start_date(cls, v):
    #     common_utils.check_date_format(v, "%Y-%m-%d %H:%M:%S")
    #     return v
    #
    # @validator('prod_end_time')
    # def date_format_validator_end_date(cls, v):
    #     common_utils.check_date_format(v, "%Y-%m-%d %H:%M:%S")
    #     return v


class OEEDataSaveRequest(BaseModel):
    prod_start_time: Optional[str]
    prod_end_time: Optional[str]
    downtime: Optional[Union[float, int]] = 0
    hierarchy: Optional[str]
    reference_id: Optional[str]
    setup_time: Optional[Union[float, int]] = 0
    cycle_time: Union[float, int] = 3
    total_units: Optional[Union[float, int]] = 0
    reject_units: Optional[Union[float, int]] = 0
    uom: Optional[str] = "mins"
    tz: Optional[str] = 'Asia/Kolkata'
    project_id: str

    class Config:
        schema_extra = {
            "example": {
                "hierarchy": "site_100$dept_100$line_100$equipment_100",
                "prod_start_time": "2022-04-22 19:49:00",
                "prod_end_time": "2022-04-22 19:49:00",
                "tz": "Asia/Kolkata",
                "project_id": "project_099",
                "reference_id": "reference_id",
                "downtime": "",
                "setup_time": "",
                "cycle_time": "",
                "total_units": "",
                "reject_units": "",
                "uom": "'"
            }
        }

    # @validator('prod_start_time')
    # def date_format_validator_start_date(cls, v):
    #     common_utils.check_date_format(v, "%Y-%m-%d %H:%M:%S")
    #     return v
    #
    # @validator('prod_end_time')
    # def date_format_validator_end_date(cls, v):
    #     common_utils.check_date_format(v, "%Y-%m-%d %H:%M:%S")
    #     return v


class BatchOEEData(OEEDataInsertRequest):
    calculated_on: str
    productive_time: float
    availability: float
    performance: float
    quality: float
    availability_loss: float
    quality_loss: float
    performance_loss: float
    oee: float

    class Config:
        orm_mode = True


class GetOEERequest(BaseModel):
    prod_start_time: int
    prod_end_time: int
    hierarchy: str


class GetOEERequestOneBatch(BaseModel):
    hierarchy: str
    reference_id: str
    project_id: str


class GetBatches(GetOEERequest):
    pass


class GetOeeServices(BaseModel):
    hierarchy: str
    project_id: str
    meta: dict
    oee_tag_mapping: str
