class TagHierarchyAggregate:
    @staticmethod
    def tag_aggregate(project_id, hierarchy_id):
        query = [
            {
                '$match': {
                    'project_id': project_id,
                    'id': {
                        '$regex': f'{hierarchy_id}'
                    }
                }
            }, {
                '$lookup': {
                    'from': 'tag_category',
                    'localField': 'tag_category_id',
                    'foreignField': 'tag_category_id',
                    'as': 'tag_category'
                }
            }, {
                '$unwind': {
                    'path': '$tag_category'
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            'k': {'$ifNull': ['$tag_category.tag_category_name', ""]},
                            'v': '$id'
                        }
                    }
                }
            }, {
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            }
        ]
        return query

    @staticmethod
    def tag_aggregate_by_hierarchy_list(project_id, hierarchy_str):
        query_json = [
            {
                '$match': {
                    'project_id': project_id,
                    'id': {
                        '$regex': hierarchy_str
                    }
                }
            }, {
                '$addFields': {
                    'new_hierarchy': {
                        '$slice': [
                            {
                                '$split': [
                                    '$id', {
                                        '$literal': '$'
                                    }
                                ]
                            }, 0, {
                                '$subtract': [
                                    {
                                        '$size': {
                                            '$split': [
                                                '$id', {
                                                    '$literal': '$'
                                                }
                                            ]
                                        }
                                    }, 1
                                ]
                            }
                        ]
                    }
                }
            }, {
                '$addFields': {
                    'hierarchy_id': {
                        '$reduce': {
                            'input': '$new_hierarchy',
                            'initialValue': '',
                            'in': {
                                '$cond': {
                                    'if': {
                                        '$eq': [
                                            {
                                                '$indexOfArray': [
                                                    '$new_hierarchy', '$$this'
                                                ]
                                            }, 0
                                        ]
                                    },
                                    'then': {
                                        '$concat': [
                                            '$$value', '$$this'
                                        ]
                                    },
                                    'else': {
                                        '$concat': [
                                            '$$value', {
                                                '$literal': '$'
                                            }, '$$this'
                                        ]
                                    }
                                }
                            }
                        }
                    }
                }
            }, {
                '$lookup': {
                    'from': 'tag_category',
                    'localField': 'tag_category_id',
                    'foreignField': 'tag_category_id',
                    'as': 'tag_category'
                }
            }, {
                '$unwind': {
                    'path': '$tag_category'
                }
            }, {
                '$group': {
                    '_id': '$hierarchy_id',
                    'data': {
                        '$push': {
                            'k': {'$ifNull': ['$tag_category.tag_category_name', ""]},
                            'v': '$id'
                        }
                    }
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            'k': '$_id',
                            'v': {
                                '$arrayToObject': '$data'
                            }
                        }
                    }
                }
            }, {
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            }
        ]
        return query_json
