from typing import Optional, List

from pydantic import BaseModel

from scripts.constants import DBConstants
from scripts.constants.ui_constants import Layouts
from scripts.utils.mongo_util import MongoCollectionBaseClass


class OeeLayoutCollection(BaseModel):
    project_id: Optional[str]
    data: List
    type: Optional[str]


class OEELayouts(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DBConstants.db_ilens_oee,
                         collection=DBConstants.collection_oee_layouts)
        self.project_id = project_id

    def update_layout(self, data, project_id, upsert=False):
        condition = {"project_id": project_id}
        return self.update_one(data=data, upsert=upsert, query=condition)

    def find_layout(self, project_id):
        condition = {"project_id": project_id}
        layout = self.find_one(query=condition)
        if not layout:
            default_layout = Layouts.default_layout
            return OeeLayoutCollection(**default_layout)
        return OeeLayoutCollection(**layout)
