from scripts.utils.kafka_util import DataPush

if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()
import time
from datetime import datetime

import pytz

from production_monitoring import ProductionMonitor

prod_mon = ProductionMonitor()
data_push = DataPush()

tag_mapping = {
    "oee": "site_100$dept_100$line_100$equipment_101$tag_215",
    "availability": "site_100$dept_100$line_100$equipment_101$tag_216",
    "performance": "site_100$dept_100$line_100$equipment_101$tag_217",
    "quality": "site_100$dept_100$line_100$equipment_101$tag_218",
    "running_lot": "site_100$dept_100$line_100$equipment_101$tag_219",
    "running_item": "site_100$dept_100$line_100$equipment_101$tag_220",
    "target": "site_100$dept_100$line_100$equipment_101$tag_222",
    "downtime": "site_100$dept_100$line_100$equipment_101$tag_223",
    "setup_time": "site_100$dept_100$line_100$equipment_101$tag_225",
    "running_time": "site_100$dept_100$line_100$equipment_101$tag_226"
}


def oee_update():
    data = prod_mon.oee_mongo.find_record_by_not_status("completed")
    if not data:
        print("No jobs are running, waiting for job to start...")
        return

    print(f"Calculating OEE for {data.get('job')}")

    data_dict = {}

    if data.get("run_start_time"):
        run_start_time = datetime.fromtimestamp(
            data.get("run_start_time") // 1000,
            tz=pytz.timezone("Asia/Bangkok")
        )

        downtime = prod_mon.automation_engine.get_downtime(
            run_start_time=run_start_time,
            production_end_time=datetime.now(tz=pytz.timezone("Asia/Bangkok"))
        )
    else:
        downtime = 0

    oee, availability, performance, quality = prod_mon.calculate_oee_params(data, downtime)

    data_dict.update(
        {
            tag_mapping.get("running_lot"): data.get("job", ""),  # job no
            tag_mapping.get("running_item"): data.get("item", ""),  # item no
            tag_mapping.get("target"): data.get("qty_released", 0),  # quality released
            tag_mapping.get("oee"): oee,
            tag_mapping.get("availability"): availability,
            tag_mapping.get("performance"): performance,
            tag_mapping.get("quality"): quality,
            tag_mapping.get("downtime"): downtime,
            tag_mapping.get("setup_time"): data.get("setup_time", 0),
            tag_mapping.get("running_time"): data.get("running_time", 0),
        }
    )

    message_dict = {
        "data": data_dict,
        "site_id": prod_mon.settings["automation"]["site_id"],
        "gw_id": "",
        "pd_id": "",
        "p_id": prod_mon.settings["automation"]["project_id"],
        "timestamp": int(time.time() * 1000),
        "msg_id": 1,
        "retain_flag": False
    }

    data_push.publish_message(message_dict)

    good_count, units_produced = prod_mon.get_current_produced_count()

    running_time = (datetime.now() - datetime.fromtimestamp(data.get("start_time") / 1000)).total_seconds() / 60

    mongo_data = {
        "good_count": good_count,
        "units_produced": units_produced,
        "running_time": running_time
    }

    data.update(mongo_data)

    prod_mon.oee_mongo.update_oee(data, data.get("job", ""), data.get("uf_process", ""), False)


if __name__ == '__main__':
    while True:
        oee_update()
        time.sleep(3)
