if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()

import time

from production_monitoring import ProductionMonitor

production_mon = ProductionMonitor()


def check_produce_start():
    data = production_mon.oee_mongo.find_record_by_status("running")
    if not data:
        print("No data found, waiting for batch to start running")
        return
    if data.get("prod_status") == "running":
        print(f"{data.get('job')} is running ....")
        if production_mon.check_production_run():
            data["prod_status"] = "producing"
            production_mon.oee_mongo.update_oee(
                data,
                data.get("job", ""),
                data.get("uf_process", ""),
                False
            )


if __name__ == '__main__':
    while True:
        check_produce_start()
        time.sleep(10)
