class Layouts:
    default_layout = {
        "type": "default",
        "data": [
            {
                "label": "OEE",
                "value": "oee",
                "description": "Displays OEE percentage",
                "show": True,
                "category": "basicOeeKpis",
                "cols": 3,
                "rows": 20,
                "minItemRows": 13,
                "minItemCols": 3,
                "x": 0,
                "y": 0
            },
            {
                "label": "Availability",
                "value": "availability",
                "description": "Displays availability percentage",
                "show": True,
                "category": "basicOeeKpis",
                "cols": 3,
                "rows": 20,
                "minItemRows": 13,
                "minItemCols": 3,
                "x": 3,
                "y": 0
            },
            {
                "label": "Performance",
                "value": "performance",
                "description": "Displays performance percentage",
                "category": "basicOeeKpis",
                "show": True,
                "cols": 3,
                "rows": 20,
                "minItemRows": 13,
                "minItemCols": 3,
                "x": 6,
                "y": 0
            },
            {
                "label": "Quality",
                "value": "quality",
                "category": "basicOeeKpis",
                "description": "Displays quantity percentage",
                "show": True,
                "cols": 3,
                "rows": 20,
                "minItemRows": 13,
                "minItemCols": 3,
                "x": 9,
                "y": 0
            },
            {
                "label": "Total Units",
                "value": "totalUnits",
                "description": "Displays number of total units.",
                "category": "quantity",
                "show": True,
                "cols": 3,
                "rows": 7,
                "minItemRows": 7,
                "minItemCols": 2,
                "x": 0,
                "y": 20
            },
            {
                "label": "Loss Analysis Graph",
                "value": "lossAnalysisGraph",
                "description": "Displays a graph showing loss analysis",
                "category": "visualization",
                "show": True,
                "cols": 6,
                "rows": 30,
                "minItemRows": 30,
                "minItemCols": 4,
                "x": 0,
                "y": 27
            },
            {
                "label": "Good Units",
                "value": "goodUnits",
                "category": "quantity",
                "description": "Displays number of good units.",
                "show": True,
                "cols": 3,
                "rows": 7,
                "minItemRows": 7,
                "minItemCols": 2,
                "x": 3,
                "y": 20
            },
            {
                "label": "Ideal Cycle per Unit",
                "value": "idealCyclePerUnit",
                "description": "Displays Ideal Cycle per Unit",
                "category": "cyclePerUnit",
                "show": True,
                "cols": 3,
                "rows": 7,
                "minItemRows": 7,
                "minItemCols": 2,
                "x": 6,
                "y": 20
            },
            {
                "label": "Actual Cycle per Unit",
                "value": "actualCyclePerUnit",
                "description": "Displays Actual Cycle per Unit",
                "category": "cyclePerUnit",
                "show": True,
                "cols": 3,
                "rows": 7,
                "minItemRows": 7,
                "minItemCols": 2,
                "x": 9,
                "y": 20
            },
            {
                "label": "Downtime Reason Log",
                "value": "downtimeReasonLog",
                "description": "Displays a table showing downtime logs",
                "show": True,
                "category": "detailedViews",
                "cols": 6,
                "rows": 29,
                "minItemRows": 20,
                "minItemCols": 6,
                "x": 6,
                "y": 27
            }
        ]
    }


class DonutChart:
    base = {
        "tooltip": {"formatter": "{a} <br/>{c} {b}"},
        "series": {
            "name": "",
            "type": "gauge",
            "radius": "100%",
            "min": 0,
            "max": 100,
            "startAngle": 180,
            "endAngle": 0,
            "axisLine": {"lineStyle": {"width": 35, "color": []}},
            "axisTick": {"show": False},
            "splitLine": {"show": False},
            "pointer": {"show": False},
            "title": {"top": 20, "offsetCenter": ["0%", "-10%"], "fontSize": 25},
            "center": ["50%", "70%"],
            "detail": {
                "color": "black",
                "formatter": "Some text",
                "fontSize": 15,
                "offsetCenter": ["0%", "30%"],
            },
            "axisLabel": {"show": False},
            "data": [],
        },
    }
    chart_keys = ["availability", "performance", "quality", "oee"]
    waterfall_chart_keys = [
        "availability_loss",
        "performance_loss",
        "quality_loss",
        "oee",
    ]
    color_mapping = {
        "oee": {"colors": ["#00AAFF", "#B8E1FF"]},
        "availability": {"colors": ["#40D62B", "#BAF4C9"]},
        "performance": {"colors": ["#FFAA00", "#FFEDB8"]},
        "quality": {"colors": ["#AD35F4", "#EFC0F4"]},
    }


class BaseWaterChart:
    @staticmethod
    def waterfall_series_builder(series):
        data = [
            ["Total Time", series[0]],
            ["Availability Loss", series[1]],
            ["Performance Loss", series[2]],
            ["Quality Loss", series[3]],
            ["OEE", series[4]],
        ]
        return data

    waterfall_base = {
        "type": "waterfall_chart_template",
        "data": {
            "backgroundColor": "white",
            "toolbox": {
                "orient": "vertical",
                "show": True,
                "right": 0,
                "feature": {
                    "saveAsImage": {
                        "title": "Save as image",
                        "name": "OEE Waterfall Chart",
                        "pixelRatio": 3
                    }
                }
            },
            "xAxis": [
                {
                    "type": "category",
                    "name": "Metrics",
                    "axisTick": {
                        "alignWithLabel": True
                    },
                    "axisLabel": {
                        "interval": 0
                    },
                    "data": [
                        "Total Time",
                        "Availability Loss",
                        "Performance Loss",
                        "Quality Loss",
                        "OEE"
                    ]
                }
            ],
            "yAxis": [
                {
                    "type": "value",
                    "name": "",
                    "offset": 0,
                    "splitLine": {
                        "show": False
                    },
                    "axisTick": {
                        "alignWithLabel": True
                    },
                    "nameLocation": "end",
                    "min": 0,
                    "max": 100
                }
            ],
            "series": [
                {
                    "type": "bar",
                    "color": "white",
                    "stack": "OEE",
                    "data": []
                },
                {
                    "label": {
                        "backgroundColor": "transparent",
                        "color": "black",
                        "distance": 5,
                        "padding": 1,
                        "position": "top",
                        "show": True
                    },
                    "type": "bar",
                    "color": "#4a0a10",
                    "stack": "OEE",
                    "data": []
                }
            ],
            "animation": True
        }
    }
