from scripts.db.mongo.ilens_configuration.aggregations.tag_hierarchy import TagHierarchyAggregate
from scripts.db.mongo.ilens_configuration.collections.tag_hierarchy import TagHierarchy
from scripts.db.mongo.schema.tag_hierarchy import GetTagsLists
from scripts.constants.db_connections import mongo_client


class TagHierarchyHandler:
    def __init__(self, project_id=None):
        self.tag_hierarchy_conn = TagHierarchy(mongo_client=mongo_client, project_id=project_id)

    def get_tags_list_by_hierarchy(self, input_data: GetTagsLists):
        try:
            aggregate_query = TagHierarchyAggregate.tag_aggregate(project_id=input_data.project_id,
                                                                  hierarchy_id=input_data.hierarchy_id)
            tag_lists = self.tag_hierarchy_conn.get_tag_hierarchy_by_aggregate(query=aggregate_query)
            tag_lists = tag_lists[0] if tag_lists else {}
            return tag_lists
        except Exception:
            raise
