from fastapi import APIRouter

from scripts.constants import Endpoints, ResponseCodes
from scripts.core.handlers.tag_handler import TagHierarchyHandler
from scripts.db.mongo.schema.tag_hierarchy import GetTagsLists
from scripts.schemas.response_models import DefaultFailureResponse, DefaultResponse

tag_service_router = APIRouter(prefix=Endpoints.api_tags,tags=["Tags Services"])


@tag_service_router.post(Endpoints.api_tags_lists)
def get_tags_list(request_data: GetTagsLists):
    try:
        tags_list = TagHierarchyHandler()
        data = tags_list.get_tags_list_by_hierarchy(request_data)
        return DefaultResponse(
            data=data,
            status=ResponseCodes.SUCCESS,
            message="Tags Categories fetched successfully",
        )
    except Exception as e:
        return DefaultFailureResponse(error=e)
