from typing import Optional

from scripts.constants import DBConstants, AssetCollectionKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class AssetOverviewSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    equipment_id: Optional[str]
    status: Optional[str]
    hierarchy: Optional[str]


class AssetOverview(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DBConstants.db_metadata,
                         collection=DBConstants.collection_asset)
        self.project_id = project_id

    @property
    def key_equipment_id(self):
        return AssetCollectionKeys.KEY_EQUIPMENT_ID

    @property
    def key_status(self):
        return AssetCollectionKeys.KEY_STATUS

    @property
    def key_hierarchy(self):
        return AssetCollectionKeys.KEY_HIERARCHY

    def update_asset_detail(self, hierarchy, data):
        """
        The following function will update the record based on hierarchy
        """
        query = {self.key_hierarchy: hierarchy}
        return self.update_one(query=query, data=data, upsert=True)

    def insert_one_asset_status(self, data):
        """
        The following function will insert one tag in the
        tags collections
        :param data:
        :return:
        """
        return self.insert_one(data)

    def find_one_asset_data(self, hierarchy):
        """
        The following function will fetch one asset overview data
        """
        query = {self.key_hierarchy: hierarchy}
        return self.find_one(query=query)

    def delete_many_tags(self, **query):
        """
        The following function will delete many tag in
        tags collection based on the given query
        :param query:
        :return:
        """
        return self.delete_many(query=query)

    def delete_one_tag(self, **query):
        """
        The following function will delete one tag in
        tags collection based on the given query
        :param query:
        :return:
        """
        if query:
            return self.delete_one(query=query)
        else:
            return False

    def distinct_tag(self, query_key):
        """
        Get a list of distinct values for `key` among all documents
        in the result set of this query.

        :param query_key:
        :return:
        """
        return self.distinct(query_key=query_key)

    def find_by_query(self, query, skip=None, limit=None, filter_dict=None):
        return list(self.find(query=query, filter_dict=filter_dict, skip=skip, limit=limit))

    def get_asset_data_by_aggregate(self, query_json: list):
        return list(self.aggregate(query_json))
