from typing import Optional, Union, Dict

from pydantic import BaseModel


class GetHierarchyRequest(BaseModel):
    type: str
    filter: Dict = dict()
    project_id: str
    site_id: Optional[str]
    node_id: Optional[str]


class LabelValue(BaseModel):
    label: str
    value: str
    start_time: Union[int, str]
    end_time: Union[int, str]
