from sqlalchemy import Float, Integer, ForeignKey, Text
from sqlalchemy import create_engine, MetaData, Column, Table
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.dialects.postgresql import JSON
from sqlalchemy.orm import relationship
from sqlalchemy.orm import sessionmaker

from scripts.logging.logging import logger as LOG
from scripts.utils.common_utils import CommonUtils

Base = declarative_base()


class TableUserEntry(Base):
    __tablename__ = "table_user_entry"
    template_id = Column(Text)
    template_json = Column(JSON)
    user_id = Column(Text)
    last_updated = Column(Float(precision=20, decimal_return_scale=True))
    id = Column(Integer, primary_key=True, autoincrement=True)
    template_instance_id = Column(Text)
    event_type = Column(Text)
    event_status = Column(Text)
    event_id = Column(Text)

    user_entry_actions = relationship('UserActions', back_populates='user_actions')

    @staticmethod
    def column_template_id():
        return 'template_id'

    @staticmethod
    def column_event_status():
        return 'event_status'

    @staticmethod
    def column_audit_type():
        return 'audit_type'

    @staticmethod
    def column_template_instance_id():
        return 'template_instance_id'

    @staticmethod
    def column_event_type():
        return 'event_type'

    @staticmethod
    def column_event_id():
        return 'event_id'

    @staticmethod
    def column_last_updated():
        return "last_updated"

    @staticmethod
    def column_user_id():
        return "user_id"

    @staticmethod
    def column_template_json():
        return "template_json"

    @staticmethod
    def column_id():
        return "id"

    def table_def_user_entry(self, meta=MetaData()):
        return Table(self.__tablename__, meta,
                     Column(self.column_template_id(), Text),
                     Column(self.column_template_json(), JSON),
                     Column(self.column_user_id(), Text),
                     Column(self.column_last_updated(), Float(precision=20, decimal_return_scale=True)),
                     Column(self.column_event_status(), Text),
                     Column(self.column_template_instance_id(), Text),
                     Column(self.column_event_type(), Text),
                     Column(self.column_event_id(), Text),
                     Column(self.column_id(), Integer, primary_key=True, autoincrement=True))

class UserActions(Base):
    __tablename__ = "user_action"
    template_id = Column(String, ForeignKey('table_user_entry.template_id')),
    action = Column(String)
    user_id = Column(String)
    last_updated = Column(Integer)
    id = Column(Integer, primary_key=True, autoincrement=True)
    audit_id = Column(String)

    user_actions = relationship('TableUserEntry', back_populates='user_entry_actions')

    @staticmethod
    def column_template_id():
        return 'template_id'

    @staticmethod
    def column_action():
        return 'action'

    @staticmethod
    def column_user_id():
        return 'user_id'

    @staticmethod
    def column_last_updated():
        return 'last_updated'

    @staticmethod
    def column_id():
        return 'id'

    @staticmethod
    def column_audit_id():
        return 'audit_id'

    def table_def_user_actions(self, meta=MetaData()):
        return Table(self.__tablename__, meta,
                     Column(self.column_template_id(), ForeignKey('table_user_entry.template_id')),
                     Column(self.column_action(), String),
                     Column(self.column_user_id(), String),
                     Column(self.column_last_updated(), Integer),
                     Column(self.column_id(), Integer, primary_key=True, autoincrement=True),
                     Column(self.column_audit_id(), String))


class SQLDBUtils(CommonUtils):
    def __init__(self, create_tables=False):
        self.filter = None
        super().__init__()
        self.engine = create_engine(self.db_endpoint(), echo=self.sqlalchemy_echo())
        if create_tables:
            self.meta = MetaData()
        session = sessionmaker()
        session.configure(bind=self.engine)
        self.session = session()

    def __del__(self):
        LOG.trace("SQL Session closed")
        self.session.close()

    def close(self):
        LOG.trace("SQL Session closed")
        self.session.close()
