import os
import sys
from configparser import SafeConfigParser, ConfigParser

from pydantic import BaseSettings

from __root__ import path


db_folder_path = os.path.join(path(), 'db')
try:
    _config = SafeConfigParser()
    APP_ENV = os.environ.get('APP_ENV')
    if not APP_ENV:
        APP_ENV = 'dev'
    _conf_path = os.path.join("conf", APP_ENV, "application.conf")
    print(_conf_path)
    _config.read(_conf_path)
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class _Configuration(BaseSettings):
    SERVICE_HOST: str = _config["SERVICE"]["host"]
    SERVICE_PORT: int = int(_config["SERVICE"]["port"])
    # ENABLE_CORS: bool = _config.getboolean("SERVICE", "cors",fallback=False)
    SERVICE_WORKERS: int = _config["SERVICE"]["workers"]
    SERVICE_THREADS: int = _config["SERVICE"]["threads"]
    LOG_ENABLE_TRACEBACK: bool = _config.getboolean('SERVICE', 'enable_traceback', fallback=False)

    MONGO_URI: str = _config.get("MONGO_DB", "uri")
    MONGO_AUTH_SOURCE: str = _config.get("MONGO_DB", "authSource")
    MONGO_AUTH_MECHANISM: str = _config.get("MONGO_DB", "authMechanism")
    METADATA_DB: str = _config.get("MONGO_DB", "metadata_db", fallback="ilens_configuration")
    MONGO_ENCRYPTION_FILE_PATH: str = _config.get("MONGO_DB", "mongo_constants_file_path",
                                                  fallback="conf/mongo_encryption_constants.json")

    LOG_LEVEL: str = _config.get("LOG", "level", fallback="trace")

    DB_TYPE: str = _config.get('DB', 'type', fallback='postgres')
    DB_HOST: str = _config.get('DB', 'host', fallback='localhost')
    DB_PORT: int = _config.get('DB', 'port', fallback=2717)
    DB_USERNAME: str = _config.get('DB', 'username', fallback=None)
    DB_PASSWORD: str = _config.get('DB', 'password', fallback=None)
    DB_NAME: str = _config.get('DB', 'name', fallback='ilens_logbook')
    SQLITE_DEFAULT_DB_PATH: str = os.path.join(db_folder_path, 'ilens_logbook.db')

    class Config:
        env_file = f'{APP_ENV}.env'
        env_file_encoding = 'utf-8'


_conf = _Configuration()


class Service(object):
    HOST = _conf.SERVICE_HOST
    PORT = _conf.SERVICE_PORT
    ALLOW_CROSS_ORIGIN = _config.getboolean("SERVICE", "cors", fallback=False)
    WORKERS = _conf.SERVICE_WORKERS
    THREADS = _conf.SERVICE_THREADS
    LOG_ENABLE_TRACEBACK = _conf.LOG_ENABLE_TRACEBACK


class MongoDB(object):
    URI = _conf.MONGO_URI
    AUTH_SOURCE = _conf.MONGO_AUTH_SOURCE
    AUTH_MECHANISM = _conf.MONGO_AUTH_MECHANISM
    METADATA_DB = _conf.METADATA_DB
    MONGO_ENCRYPTION_FILE_PATH = _conf.MONGO_ENCRYPTION_FILE_PATH


class ApplicationKeys(object):
    username_decryption_key = "H)8A$R%^S~H12@A/"
    password_decryption_key = 'QVY1bWdMQ0Zxc'


class SqlDB(object):
    DB_TYPE = _conf.DB_TYPE
    DB_HOST = _conf.DB_HOST
    DB_PORT = _conf.DB_PORT
    DB_USERNAME = _conf.DB_USERNAME
    DB_PASSWORD = _conf.DB_PASSWORD
    DB_NAME = _conf.DB_NAME
    SQLITE_DEFAULT_DB_PATH = _conf.SQLITE_DEFAULT_DB_PATH


class Log(object):
    LOG_LEVEL = _conf.LOG_LEVEL
