from sqlalchemy import String, JSON, Float, Integer
from sqlalchemy import create_engine, MetaData, Column, Table
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker

from scripts.logging.logging import logger as LOG
from scripts.utils.common_utils import CommonUtils

Base = declarative_base()


class TableAudits(Base):
    __tablename__ = "table_user_entry"
    template_id = Column(String)
    template_json = Column(JSON)
    user_id = Column(String)
    last_updated = Column(Float(precision=20, decimal_return_scale=True))
    id = Column(Integer, primary_key=True, autoincrement=True)

    @staticmethod
    def column_template_id():
        return 'template_id'

    @staticmethod
    def column_audit_type():
        return 'audit_type'

    @staticmethod
    def column_audit_time():
        return 'audit_time'

    @staticmethod
    def column_audit_mapping_id():
        return 'audit_mapping_id'

    @staticmethod
    def column_audit_message():
        return 'audit_message'

    def table_def_audits(self, meta=MetaData()):
        return Table(self.__tablename__, meta,
                     Column(self.column_audit_id(), String(64), primary_key=True),
                     Column(self.column_audit_type(), String(64)),
                     Column(self.column_audit_time(), BigInteger),
                     Column(self.column_audit_mapping_id(), String(64)),
                     Column(self.column_audit_message(), String(2048)), extend_existing=True)


class SQLDBUtils(CommonUtils):
    def __init__(self, create_tables=False):
        self.filter = None
        super().__init__()
        self.engine = create_engine(self.db_endpoint(), echo=self.sqlalchemy_echo())
        if create_tables:
            self.meta = MetaData()
        session = sessionmaker()
        session.configure(bind=self.engine)
        self.session = session()

    def __del__(self):
        LOG.trace("SQL Session closed")
        self.session.close()

    def close(self):
        LOG.trace("SQL Session closed")
        self.session.close()
