from abc import ABC

import gunicorn.app.base

from main import app


class StandaloneApplication(gunicorn.app.base.BaseApplication, ABC):

    def __init__(self, application, options=None):
        self.options = options or {}
        self.application = application
        super().__init__()

    def load_config(self):
        config = {key: value for key, value in self.options.items()
                  if key in self.cfg.settings and value is not None}
        for key, value in config.items():
            self.cfg.set(key.lower(), value)

    def load(self):
        return self.application


def run_app(host, port, workers, threads):
    options = {
        'bind': '%s:%s' % (host, port),
        'workers': workers,
        'threads': threads
    }
    StandaloneApplication(app, options).run()
