import platform
import argparse
from scripts.constants import Conf
if platform.system().lower() != 'windows':
    from app.gunicorn_config import run_app
else:
    from app.waitress_config import run_app


if __name__ == '__main__':
    ap = argparse.ArgumentParser()
    ap.add_argument("--host", "-H", required=False, default=Conf.HOST,
                    help="Port to start the application.")
    ap.add_argument("--port", "-P", required=False, default=Conf.PORT,
                    help="Port to start the application.")
    ap.add_argument("--threads", "-T", required=False, default=Conf.THREADS,
                    help="Number of threads the application.")
    ap.add_argument("--workers", "-W", required=False, default=Conf.WORKERS,
                    help="Number of threads the application.")
    arguments = vars(ap.parse_args())

    host = arguments["host"]
    user_selected_port = int(arguments["port"])
    threads = int(arguments["threads"])
    workers = int(arguments['workers'])
    run_app(host=host, port=user_selected_port, workers=workers, threads=threads)
