import traceback

from fastapi import APIRouter
from pymongo import MongoClient

from scripts.config import DBConf, DatabaseConstants
from scripts.logging.logging import logger
from scripts.services.get_baseurl_schema import GetBaseUrl
from scripts.services.response_models import DefaultMobileResponse

client_info_router = APIRouter(tags=["Client List Services"])


@client_info_router.post("/client/get_baseurl")
def get_baseurl(request_data: GetBaseUrl):
    try:
        mongo_connection_obj = MongoClient(DBConf.MONGO_URI)
        mongo_obj = mongo_connection_obj[DatabaseConstants.ilens_clients_db][DatabaseConstants.ilens_clients_collection]
        data = mongo_obj.find_one({"client_id": request_data.name})
        data = dict(data) if bool(data) else dict()
        response_data = data.get("data", {})
        if not bool(response_data):
            raise Exception
        return DefaultMobileResponse(status=True, message="Success", data=response_data)
    except Exception as e:
        logger.exception(e)
        logger.exception(traceback.format_exc())
        return DefaultMobileResponse(status=False, message="Could'nt find the data")
