from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from scripts.services.get_baseurl import client_info_router

app = FastAPI(
    title="iLens Clients",
    version="1.0.0",
    description="ILENS ASSISTANT App",
)

app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["GET", "POST", "DELETE", "PUT"],
    allow_headers=["*"],
)

app.include_router(client_info_router)