import json

if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv()
import os
import sys
import time

from scripts.core import ILensVersionHandler
from scripts.core.docker_handler import DockerHandler
from scripts.core.git_handler import GitHandler
from scripts.logging import logging
from scripts.utils.common_utils import CommonUtils

docker_repo = os.environ.get("DOCKER_REPO",
                             default="https://gitlab-pm.knowledgelens.com/KnowledgeLens/Products/iLens-2.0/core/devops/docker-compose.git")
global_configmap = os.environ.get("GLOBAL_VARIABLES_FILE", default="ilens-env-spec-variables.yml")


class DockerRegistration:
    def __init__(self, arguments: dict, git_user_name: str, git_access_token: str):
        self.arguments = arguments
        self.db_handler = ILensVersionHandler()
        self.docker_handler = DockerHandler(git_user_name=git_user_name, git_access_token=git_access_token)
        self.git_handler_obj = GitHandler(user_name=git_user_name, access_token=git_access_token)
        self.common_util = CommonUtils()

    def module_registration(self):
        docker_temp_path = f"{int(time.time())}_docker_tmp_path"
        general_temp_path = f"{int(time.time())}_tmp"
        output_path = f"{int(time.time())}_docker-compose"
        try:
            _ilens_version = self.arguments["ilens_version"]
            _release_version = self.arguments["release_version"]
            _client_name = self.arguments['client_name']
            _reference_branch = self.arguments['reference_client_name']
            _git_repos = self.arguments["git_repos"]
            _module_names = self.arguments["module_names"]
            _branch_name = self.arguments['branch_name'] or "master"
            if repo_info := self.arguments["repo_info"]:
                repo_info = json.loads(repo_info)
            if not _ilens_version or not _release_version or not _client_name or not _git_repos and not _module_names or not global_configmap:
                print(
                    "global_configmap, git_repos, module_names, client_name, ilens_version and release_version details not found!!!!!")
                sys.exit()
            _branch = f"{_client_name}_{_ilens_version}.{_release_version}"
            if not os.path.exists(docker_temp_path):
                os.makedirs(docker_temp_path)
            if not os.path.exists(output_path):
                os.makedirs(output_path)
            docker_compose_path = os.path.join(docker_temp_path, "docker-compose")
            if not self.git_handler_obj.clone_repository(repo_link=docker_repo, module_output_path=docker_compose_path,
                                                         clone_branch=_reference_branch or _client_name):
                logging.error(f"Cannot clone docker repo with branch: {_reference_branch or _client_name}")
            docker_compose_path = os.path.join(docker_temp_path, "docker-compose")
            variables_file = "variables.yml"
            if os.path.exists(docker_compose_path):
                self.docker_handler.process_compose_data_for_existing_files(destination_branch=_client_name,
                                                                            source_branch=_branch,
                                                                            variables_file=variables_file,
                                                                            arguments=self.arguments,
                                                                            tmp_path=general_temp_path,
                                                                            output_path=output_path,
                                                                            docker_compose_path=docker_compose_path)
            else:
                self.docker_handler.process_compose_data_by_template(variables_file=variables_file,
                                                                     arguments=self.arguments, compose_info=repo_info,
                                                                     tmp_path=general_temp_path,
                                                                     output_path=output_path, modules=_module_names)

        except Exception as e:
            logging.exception(f"Exception Occurred while generating the docker compose file {e.args}")
