import os

from scripts.logging import logging
from scripts.utils.common_utils import CommonUtils


class HelmHandler:
    def __init__(self):
        self.common_utils = CommonUtils()
        ...

    def create_existing_helm_deployment_file(self, template_yml_path, module_env_variables: dict,
                                             global_config_data: dict,
                                             image_tag: str, module_name: str, template_file: str,
                                             helm_out_file_path: str,
                                             template_path: str, service_type=True):
        try:
            if not os.path.exists(template_yml_path):
                logging.debug(f"{template_yml_path} not found!! Skipping Helm File Preparation")
                return False
            existing_data = self.common_utils.convert_yaml_to_define_obj(template_yml_path)
            global_config_vars = global_config_data.get('data', {})
            existing_env_variables = {_v['name']: _v for _v in
                                      existing_data.get('deployment', {}).get('environmentVar', [])}
            diff_keys = list(set(existing_env_variables.keys()).symmetric_difference(set(module_env_variables.keys())))
            for _each in diff_keys:
                if _each.lower() in {'port', 'service_port', 'module_port'} and module_env_variables.get(_each) and \
                        module_env_variables[_each].get("value"):
                    global_config_vars["SERVICE_PORT"] = module_env_variables[_each]["value"]
                    continue
                if module_env_variables.get(_each):
                    existing_data['deployment']['environmentVar'].append(module_env_variables[_each])
            existing_data['deployment']['imageName'] = image_tag or existing_data['deployment']['imageName']

            self.common_utils.convert_json_to_yaml(json_data=existing_data, output_file_path=template_file)
            self.common_utils.render_deployment_chart(data_dict=global_config_vars, jinja_template_file=f'{module_name}.yml',
                                                      outfile_path=helm_out_file_path, template_path=template_path,
                                                      service_type=service_type)
            return True
        except Exception as e:
            logging.exception(f'Exception occurred while preparing the helm deployment file {e.args}')
            return False

    def create_helm_deployment_file(self, template_yml_path, module_env_variables: dict, global_config_data: dict,
                                    image_tag: str, module_name: str, helm_out_file_path: str, service_type=True):
        try:
            if not os.path.exists(template_yml_path):
                logging.debug(f"{template_yml_path} not found!! Skipping Helm File Preparation")
                return False
            global_config_vars = global_config_data.get('data', {})
            module_port = node_port = ''
            for k, v in module_env_variables.items():
                if k.lower() in {'port', 'service_port', 'module_port'} and v:
                    if 'module_port' not in global_config_vars:
                        module_port = v
                    if 'node_port' not in global_config_vars:
                        node_port = v
                    continue
                if global_config_vars.get(k):
                    continue
                value_key = v.strip("{{ }}")
                global_config_vars.update({k: global_config_vars.get(value_key, v)})

            self.common_utils.render_deployment_chart(data_dict={}, jinja_template_file=f'{module_name}.yml',
                                                      outfile_path=helm_out_file_path, template_path="templates",
                                                      service_type=service_type, image_url=image_tag,
                                                      variables=global_config_vars,
                                                      module_port=module_port, node_port=node_port)
            return True
        except Exception as e:
            logging.exception(f'Exception occurred while preparing the helm deployment file {e.args}')
            return False
