import os

import jinja2
import ruamel.yaml

from scripts.logging import logging


class CommonUtils:

    @staticmethod
    def add_quotes(file_path):
        my_data = ""
        with open(file_path, "r+") as f:
            data = f.read()
            data = data.replace("{{", '\"{{')
            data = data.replace("}}", '}}\"')
            my_data = data
            f.write(data)
        with open(file_path, "w+") as f:
            f.write(my_data)
    @staticmethod
    def convert_yaml_to_define_obj(yaml_file_path, load_type='safe'):
        try:
            if not os.path.exists(yaml_file_path):
                return {}
            _yaml = ruamel.yaml.YAML(typ=load_type)
            _yaml.preserve_quotes = True
            _yaml.allow_duplicate_keys = True
            with open(yaml_file_path) as fpi:
                yaml_dict = _yaml.load(fpi)
            return yaml_dict
        except Exception as e:
            logging.exception(f"Exception Occurred while reading the yaml file {e.args}")
            return {}

    @staticmethod
    def convert_json_to_yaml(json_data: dict, output_file_path):
        try:
            yaml = ruamel.yaml.YAML()
            yaml.preserve_quotes = True
            with open(output_file_path, 'w') as yaml_file:
                yaml.dump(json_data, yaml_file)
        except Exception as e:
            logging.exception(f"Exception Occurred while reading the yaml file {e.args}")
            return False

    @staticmethod
    def render_deployment_chart(data_dict, jinja_template_file, template_path, outfile_path, **kwargs):
        try:
            environment = jinja2.Environment(
                loader=jinja2.FileSystemLoader(searchpath=template_path),
                trim_blocks=True, autoescape=True)
            _render = environment.get_template(jinja_template_file).render(**kwargs, **data_dict)
            with open(outfile_path, "w") as fp:
                fp.write(_render)

        except Exception as e:
            logging.exception(f"Exception occurred while rendering the helm file  - {e.args}")
